#!/bin/sh

# This script is used to generate souce files containing test
# data for the ramdisk_extractor unit tests.

set -e

export LANG=C
export LC_ALL=C

PROGNAME=$(basename "$0")
DATE=$(date +%Y-%m-%d)

# $1: Root directory
create_ramdisk_header_from () {
    local FILE_LIST
    FILE_LIST=$(cd $2 && find . -type f 2>/dev/null | sed -e 's|^./||g')
    echo "$FILE_LIST" | cpio --create --format=newc --quiet | gzip -9c | xxd -i -
}

TMPDIR=/tmp/$USER-ramdisk-test-data
rm -rf $TMPDIR/dir1 && mkdir -p $TMPDIR/dir1
cd $TMPDIR/dir1
cat > foo <<EOF
Hello World!
EOF
cat > bar2 <<EOF
La vie est un long fleuve tranquille
EOF

echo "/* Auto-generated by $PROGNAME on $DATE - DO NOT EDIT!! */"
echo ""
echo "static const unsigned char kTestRamdiskImage[] = {"
create_ramdisk_header_from $TMPDIR/ramdisk1.img.h $TMPDIR/dir1
echo "};"
echo ""
echo "static const size_t kTestRamdiskImageSize = sizeof(kTestRamdiskImage);"
echo ""

